<?php

namespace ViartasBuilders\Forms\Fields;

use ViartasBuilders\Forms\Contracts\FieldContract;
use ViartasBuilders\Forms\Field;
use ViartasBuilders\Forms\Traits\HasTranslations;
use Illuminate\Support\Facades\Blade;

class TextField extends Field implements FieldContract
{
    use HasTranslations;

    protected string $component = '<x-form-element-text :field="$field" />';

    public function __construct(array $config = [])
    {
        $this->setRules([
            'string', 'max:255',
        ]);

        parent::__construct($config);
    }

    public function render(): string
    {
        return Blade::render($this->component, ['field' => $this]);
    }
}
