<?php

namespace ViartasBuilders\Forms\Fields;

use ViartasBuilders\Forms\Contracts\FieldContract;
use ViartasBuilders\Forms\Field;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Blade;

class SelectField extends Field implements FieldContract
{
    protected bool $nested = false;
    protected array $nested_fields = [];

    public function render(): string
    {
        return Blade::render('<x-form-element-select :field="$field" />', ['field' => $this]);
    }

    public function setOptions(array|Collection $options = []): self
    {
        $this->options = $options;
        return $this;
    }

    /**
     * @return bool
     */
    public function nested(): bool
    {
        return $this->nested;
    }

    /**
     * @param bool $nested
     * @return self
     */
    public function setNested(bool $nested): self
    {
        return $this->setAttribute('nested', $nested);
    }

    /**
     * @return array
     */
    public function nested_options(): array
    {
        return $this->nested_options();
    }

    /**
     * @param array $options
     * @return self
     */
    public function setNestedOptions(array $options): self
    {
        return $this->setAttribute('nested_options', $options);
    }
}
