<?php

namespace ViartasBuilders\Forms\Fields;

use ViartasBuilders\Forms\Contracts\FieldContract;
use ViartasBuilders\Forms\Field;
use ViartasBuilders\Forms\Traits\HasTranslations;
use Illuminate\Support\Facades\Blade;

class PasswordField extends Field implements FieldContract
{
    protected string $component = '<x-form-element-password :field="$field" />';

    public function __construct(array $config = [])
    {
        $this->setRules([
            'string', 'min:4', 'max:255'
        ]);

        $this->setPrimaryKey('id');
        $this->setPrimaryValue(request()->id ?? false);

        parent::__construct($config);
    }

    public function render(): string
    {
        return Blade::render($this->component, ['field' => $this]);
    }

    /**
     * @return $this
     */
    public function beforeValidation(): self
    {
        if (!$this->primaryKey()) {
            return $this;
        }

        $model = new $this->model();
        $model = $model->where($this->primaryKey(), $this->primaryValue())->first();

        if (!$model) {
            $this->setRules(array_merge($this->rules(), [
                    'required',
                ]
            ));
        }

        return $this;
    }
}
