<?php

namespace ViartasBuilders\Forms\Fields;

use ViartasBuilders\Forms\Contracts\FieldContract;
use ViartasBuilders\Forms\Field;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Blade;

class MediaField extends Field implements FieldContract
{
    protected string $route = 'accounting.media.upload';
    protected array $route_attributes = [];
    protected int $max_files = 9999;
    protected int $max_filesize = 10;
    protected string $collection = 'images';
    protected string $disk = 'public';
    protected array $mimes = ['jpg', 'jpeg', 'png', 'gif'];
    protected string|null $model = Model::class;
    protected string|null $primary_key = 'id';
    protected string|null $primary_value = null;

    public function __construct(array $config = [])
    {
        $this->setRules([
            'nullable', 'mimes:'.implode(',', $this->mimes)
        ]);

        parent::__construct($config);
    }

    /**
     * @return string
     */
    public function render(): string
    {
        if (!$this->primaryValue()) {
            return '';
        }

        return Blade::render('<x-form-element-media :field="$field" />', ['field' => $this]);
    }

    /**
     * @return string
     */
    public function route(): string
    {
        return $this->route;
    }

    /**
     * @param string $route
     * @return self
     */
    public function setRoute(string $route): self
    {
        return $this->setAttribute('route', $route);
    }

    /**
     * @return array
     */
    public function routeAttributes(): array
    {
        return $this->route_attributes;
    }

    /**
     * @param array $attributes
     * @return self
     */
    public function setRouteAttributes(array $attributes): self
    {
        return $this->setAttribute('route_attributes', $attributes);
    }

    /**
     * @return string
     */
    public function collection(): string
    {
        return $this->collection;
    }

    /**
     * @param string $collection
     * @return self
     */
    public function setCollection(string $collection): self
    {
        return $this->setAttribute('collection', $collection);
    }

    /**
     * @return string
     */
    public function disk(): string
    {
        return $this->disk;
    }

    /**
     * @param string $disk
     * @return self
     */
    public function setDisk(string $disk): self
    {
        return $this->setAttribute('disk', $disk);
    }

    /**
     * @return string|null
     */
    public function model(): string|null
    {
        return $this->model;
    }

    /**
     * @param string $model
     * @return self
     */
    public function setModel(string $model): self
    {
        return $this->setAttribute('model', $model);
    }

    /**
     * @return string
     */
    public function primaryKey(): string|null
    {
        return $this->primary_key;
    }

    /**
     * @param string $key
     * @return self
     */
    public function setPrimaryKey(string $key): self
    {
        return $this->setAttribute('primary_key', $key);
    }

    /**
     * @return string
     */
    public function primaryValue(): string|null
    {
        return $this->primary_value;
    }

    /**
     * @param string $value
     * @return self
     */
    public function setPrimaryValue(string $value): self
    {
        return $this->setAttribute('primary_value', $value);
    }

    /**
     * @return string
     */
    public function maxFiles(): string
    {
        return $this->max_files;
    }

    /**
     * @param int $maxFiles
     * @return self
     */
    public function setMaxFiles(int $maxFiles): self
    {
        return $this->setAttribute('max_files', $maxFiles);
    }

    /**
     * @return string
     */
    public function maxFileSize(): string
    {
        return $this->max_filesize;
    }

    /**
     * @param int $maxFileSize
     * @return self
     */
    public function setMaxFileSeize(int $maxFileSize): self
    {
        return $this->setAttribute('max_filesize', $maxFileSize);
    }
}
