<?php

namespace ViartasBuilders\Forms\Fields;

use ViartasBuilders\Forms\Contracts\FieldContract;
use ViartasBuilders\Forms\Field;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Blade;

class CheckboxField extends Field implements FieldContract
{
    public function __construct(array $config = [])
    {
        parent::__construct($config);
    }

    public function render(): string
    {
        return Blade::render('<x-form-element-checkbox :field="$field" />', ['field' => $this]);
    }

    public function setOptions(array|Collection $options = []): self
    {
        $this->options = $options;
        return $this;
    }
}
