<?php

namespace ViartasBuilders\Forms;

use ViartasBuilders\Forms\Fields\BlankField;
use ViartasBuilders\Forms\Fields\CheckboxField;
use ViartasBuilders\Forms\Fields\MediaField;
use ViartasBuilders\Forms\Fields\PasswordField;
use ViartasBuilders\Forms\Fields\SelectField;
use ViartasBuilders\Forms\Fields\SubmitField;
use ViartasBuilders\Forms\Fields\TextareaField;
use ViartasBuilders\Forms\Fields\TextField;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Session;
class Field
{
    const BLANK = BlankField::class;
    const TEXT = TextField::class;
    const TEXTAREA = TextareaField::class;
    const SELECT = SelectField::class;
    const CHECKBOX = CheckboxField::class;
    const RADIO = 'radio';
    const PASSWORD = PasswordField::class;
    const HIDDEN = 'hidden';
    const FILE = 'file';
    const CALENDAR = 'calendar';
    const COLOR = 'color';
    const MEDIA = MediaField::class;
    const EMAIL = 'email';
    const RANGE = 'range';
    const ENTITY = 'entity';
    const BUTTON_SUBMIT = SubmitField::class;
    const BUTTON_BUTTON = 'button';

    private string $title = 'example_title';
    private string $description = '';
    private string $name = 'example_field';
    private string $group = 'example_group';

    private string $id = "";
    private string $class = "";
    private string $parent_class = "form-group fv-row mb-5";
    private bool $placeholder = false;
    private string $label_position = "top";
    private string $position = "";
    private string $icon = "";
    private int $size = 12;
    private bool $hidden = false;
    private bool $disabled = false;
    private bool $readonly = false;
    private bool $required = false;
    private bool $multiple = false;
    private bool $confirmation = false;
    private array $rules = [];
    private array $customRules = [];
    private array|Collection $options = [];
    private mixed $value = '';
    private string $request_name = 'example_field';
    private mixed $validation_status = '';

    protected string|null $model = null;
    protected string|null $primary_key = null;
    protected string|null $primary_value = null;
    protected bool $inline = false;

    /**
     * if fields has ID && filed model == model => set id = id;
     * if field had model && field has NO id, not render field
     * @param array $config
     */
    public function __construct(array $config = [])
    {
        return $this->setConfigFromArray($config);
    }

    /**
     * @param array $config
     * @return self
     */
    private function setConfigFromArray(array $config): self
    {
        foreach ($config as $key => $value) {
            $this->{$key} = $value;
        }

        return $this;
    }

    /**
     * @return $this
     */
    public function buildRequest(): self
    {
        $this->buildRequestName();
        $this->buildRequestValues();
        $this->buildValidationStatus();

        return $this;
    }

    /**
     * @return void
     */
    private function buildRequestName(): void
    {
        $this->request_name = str_replace('[]', '', $this->name);
        $this->request_name = str_replace('[', '.', $this->request_name);
        $this->request_name = str_replace(']', '', $this->request_name);
    }

    /**
     * @return $this
     */
    public function beforeValidation(): self
    {
        return $this;
    }

    /**
     * @return void
     */
    private function buildRequestValues(): void
    {
        $this->value = request()->old($this->request_name) ? request()->old($this->request_name) : $this->value;
    }

    /**
     * @return void
     */
    private function buildValidationStatus(): void
    {
        $errors = Session::get('errors');

        if ($errors) {
            if ($errors->has($this->request_name)) {
                $this->validation_status = 'invalid';
            } else {
                $this->validation_status = 'valid';
            }
        }
    }

    /**
     * @param string $key
     * @param mixed $value
     * @return self
     */
    protected function setAttribute(string $key, mixed $value): self
    {
        $this->{$key} = $value;
        return $this;
    }

    /**
     * @param string $attribute
     * @param mixed $value
     * @return self
     */
    public function set(string $attribute, mixed $value): self
    {
        return $this->setAttribute($attribute, $value);
    }

    /**
     * @return string|null
     */
    public function model(): string|null
    {
        return $this->model;
    }

    /**
     * @param string $model
     * @return self
     */
    public function setModel(string $model): self
    {
        return $this->setAttribute('model', $model);
    }

    /**
     * @return string
     */
    public function primaryKey(): string|null
    {
        return $this->primary_key;
    }

    /**
     * @param string $key
     * @return self
     */
    public function setPrimaryKey(string $key): self
    {
        return $this->setAttribute('primary_key', $key);
    }

    /**
     * @return string|null
     */
    public function primaryValue(): string|null
    {
        return $this->primary_value;
    }

    /**
     * @param string $value
     * @return self
     */
    public function setPrimaryValue(string $value): self
    {
        return $this->setAttribute('primary_value', $value);
    }

    /**
     * @param string $description
     * @return self
     */
    public function setDescription(string $description): self
    {
        return $this->setAttribute('description', $description);
    }

    /**
     * @return string
     */
    public function description(): string
    {
        return $this->description;
    }

    /**
     * @param string $title
     * @return self
     */
    public function setTitle(string $title): self
    {
        return $this->setAttribute('title', $title);
    }

    /**
     * @return string
     */
    public function title(): string
    {
        return $this->title;
    }

    /**
     * @return bool
     */
    public function placeholder(): bool
    {
        return $this->placeholder;
    }

    /**
     * @return string
     */
    public function parent_class(): string
    {
        return $this->parent_class;
    }

    /**
     * @return string
     */
    public function label_position(): string
    {
        return $this->label_position;
    }

    /**
     * @param string $name
     * @return self
     */
    public function setName(string $name): self
    {
        return $this->setAttribute('name', $name);
    }

    /**
     * @return string
     */
    public function name(): string
    {
        return $this->name;
    }

    /**
     * @param mixed $value
     * @return self
     */
    public function setValue(mixed $value): self
    {
        return $this->setAttribute('value', $value);
    }

    /**
     * @return mixed
     */
    public function value(): mixed
    {
        return $this->value;
    }

    /**
     * @param bool $inline
     * @return self
     */
    public function setInline(bool $inline): self
    {
        return $this->setAttribute('inline', $inline);
    }

    /**
     * @return mixed
     */
    public function inline(): bool
    {
        return $this->inline;
    }

    /**
     * @param string $group
     * @return self
     */
    public function setGroup(string $group): self
    {
        return $this->setAttribute('group', $group);
    }

    /**
     * @return string
     */
    public function group(): string
    {
        return $this->group;
    }

    /**
     * @param string $id
     * @return self
     */
    public function setId(string $id): self
    {
        return $this->setAttribute('id', $id);
    }

    /**
     * @return string
     */
    public function id(): string
    {
        return $this->id;
    }

    /**
     * @param string $class
     * @return self
     */
    public function setClass(string $class): self
    {
        return $this->setAttribute('class', $class);
    }

    /**
     * @return string
     */
    public function class(): string
    {
        return $this->class;
    }

    /**
     * @param int $size
     * @return self
     */
    public function setSize(int $size): self
    {
        return $this->setAttribute('size', $size);
    }

    /**
     * @return int
     */
    public function size(): int
    {
        return $this->size;
    }

    /**
     * @param bool $hidden
     * @return self
     */
    public function setHidden(bool $hidden = true): self
    {
        return $this->setAttribute('hidden', $hidden);
    }

    /**
     * @return string
     */
    public function hidden(): string
    {
        return $this->hidden;
    }

    /**
     * @return array
     */
    public function customRules(): array
    {
        return $this->customRules;
    }

    /**
     * @param array $rules
     * @return self
     */
    public function setCustomRules(array $rules): self
    {
        return $this->setAttribute('customRules', $rules);
    }

    /**
     * @param array $rules
     * @return self
     */
    public function setRules(array $rules): self
    {
        return $this->setAttribute('rules', $rules);
    }

    /**
     * @return array
     */
    public function rules(): array
    {
        return $this->rules;
    }

    /**
     * @param string $position
     * @return self
     */
    public function setPosition(string $position): self
    {
        return $this->setAttribute('position', $position);
    }

    /**
     * @return string
     */
    public function position(): string
    {
        return $this->position;
    }

    /**
     * @param string $icon
     * @return self
     */
    public function setIcon(string $icon): self
    {
        return $this->setAttribute('icon', $icon);
    }

    /**
     * @return string
     */
    public function icon(): string
    {
        return $this->icon;
    }

    /**
     * @param bool $disabled
     * @return self
     */
    public function setDisabled(bool $disabled = true): self
    {
        return $this->setAttribute('disabled', $disabled);
    }

    /**
     * @return string
     */
    public function disabled(): string
    {
        return $this->disabled;
    }

    /**
     * @param bool $readonly
     * @return self
     */
    public function setReadonly(bool $readonly = true): self
    {
        return $this->setAttribute('readonly', $readonly);
    }

    /**
     * @return string
     */
    public function readonly(): string
    {
        return $this->readonly;
    }

    /**
     * @param bool $required
     * @return self
     */
    public function setRequired(bool $required = true): self
    {
        return $this->setAttribute('required', $required);
    }

    /**
     * @return string
     */
    public function required(): string
    {
        return $this->required;
    }

    /**
     * @param bool $multiple
     * @return self
     */
    public function setMultiple(bool $multiple = true): self
    {
        return $this->setAttribute('multiple', $multiple);
    }

    /**
     * @return string
     */
    public function multiple(): string
    {
        return $this->multiple;
    }

    /**
     * @param bool $multiple
     * @return self
     */
    public function setMConfirmatione(bool $confirmation = true): self
    {
        return $this->setAttribute('confirmation', $confirmation);
    }

    /**
     * @return string
     */
    public function confirmation(): string
    {
        return $this->confirmation;
    }

    /**
     * @param array|Collection $options
     * @return self
     */
    public function setOptions(array|Collection $options): self
    {
        return $this->setAttribute('options', $options);
    }

    /**
     * @return array|Collection
     */
    public function options(): array|Collection
    {
        return $this->options;
    }

    /**
     * @return string
     */
    public function request_name(): string
    {
        return $this->request_name;
    }

    /**
     * @return string
     */
    public function validation_status(): string
    {
        return $this->validation_status;
    }

//    protected function reqest()
//    {
//        if ($this->requeset) {
//            return $this->request;
//        }
//
//        return $this->request = request();
//    }
}
