<?php

namespace ViartasBuilders\Forms\Contracts;

use ViartasBuilders\Forms\Group;

Interface GroupContract

{
    /**
     * @param array $config
     */
    function __construct(array $config = []);

    /**
     * @param string|null $component
     * @param array|null $attributes
     * @return string
     */
    function render(string|null $component, array|null $attributes): string;

    /**
     * @return array
     */
    function attributes (): array;

    /**
     * @param string $name
     * @return Group
     */
    public function setName(string $name): Group;

    /**
     * @return string
     */
    public function name(): string;

    /**
     * @param string $title
     * @return Group
     */
    public function setTitle(string $title): Group;

    /**
     * @return string
     */
    public function title(): string;

    /**
     * @param string $id
     * @return Group
     */
    public function setId(string $id): Group;

    /**
     * @return string
     */
    public function id(): string;

    /**
     * @param string $class
     * @return Group
     */
    public function setClass(string $class): Group;

    /**
     * @return string
     */
    public function class(): string;

    /**
     * @param int $size
     * @return Group
     */
    public function setSize(int $size): Group;

    /**
     * @return int
     */
    public function size(): int;

    /**
     * @param string $content
     * @return Group
     */
    public function setContentTop(string $content): Group;

    /**
     * @return string
     */
    public function contentTop(): string;

    /**
     * @param string $content
     * @return Group
     */
    public function setContentBottom(string $content): Group;

    /**
     * @return string
     */
    public function contentBottom(): string;
}
