<?php

namespace ViartasBuilders\Forms\Contracts;

use ViartasBuilders\Forms\Field;
use Illuminate\Support\Collection;

Interface FieldContract

{
    /**
     * @param array $config
     */
    function __construct(array $config = []);

    /**
     * @return string
     */
    public function render(): string;

    /**
     * @param string $title
     * @return Field
     */
    public function setTitle(string $title): Field;

    /**
     * @return string
     */
    public function title(): string;

    /**
     * @param string $name
     * @return Field
     */
    public function setName(string $name): Field;

    /**
     * @return string
     */
    public function name(): string;

    /**
     * @param mixed $value
     * @return Field
     */
    public function setValue(mixed $value): Field;

    /**
     * @return mixed
     */
    public function value(): mixed;

    /**
     * @param string $group
     * @return Field
     */
    public function setGroup(string $group): Field;

    /**
     * @return string
     */
    public function group(): string;

    /**
     * @param string $id
     * @return Field
     */
    public function setId(string $id): Field;

    /**
     * @return string
     */
    public function id(): string;

    /**
     * @param string $class
     * @return Field
     */
    public function setClass(string $class): Field;

    /**
     * @return string
     */
    public function class(): string;

    /**
     * @param int $size
     * @return Field
     */
    public function setSize(int $size): Field;

    /**
     * @return int
     */
    public function size(): int;

    /**
     * @param bool $hidden
     * @return Field
     */
    public function setHidden(bool $hidden = true): Field;

    /**
     * @return string
     */
    public function hidden(): string;

    /**
     * @param array $rules
     * @return Field
     */
    public function setRules(array $rules): Field;

    /**
     * @return array
     */
    public function rules(): array;

    /**
     * @param string $position
     * @return Field
     */
    public function setPosition(string $position): Field;

    /**
     * @return string
     */
    public function position(): string;

    /**
     * @param string $icon
     * @return Field
     */
    public function setIcon(string $icon): Field;

    /**
     * @return string
     */
    public function icon(): string;

    /**
     * @param bool $disabled
     * @return Field
     */
    public function setDisabled(bool $disabled = true): Field;

    /**
     * @return string
     */
    public function disabled(): string;

    /**
     * @param bool $readonly
     * @return Field
     */
    public function setReadonly(bool $readonly = true): Field;

    /**
     * @return string
     */
    public function readonly(): string;

    /**
     * @param bool $required
     * @return Field
     */
    public function setRequired(bool $required = true): Field;

    /**
     * @return string
     */
    public function required(): string;

    /**
     * @param bool $multiple
     * @return Field
     */
    public function setMultiple(bool $multiple = true): Field;

    /**
     * @return string
     */
    public function multiple(): string;

    /**
     * @param array|Collection $options
     * @return Field
     */
    public function setOptions(array|Collection $options): Field;

    /**
     * @return array|Collection
     */
    public function options(): array|Collection;

    /**
     * @return string
     */
    public function request_name(): string;

    /**
     * @return string
     */
    public function validation_status(): string;
}
