<form
    action="{{ $form->_route() }}"
    method="{{ $form->_method() }}"
    id="{{ $form->id() }}"
    class="{{ $form->class() }}"
    enctype="multipart/form-data"
    x-data="{ locale: '{{ app()->getLocale() }}' }"
>
    @csrf
    <div class="row">
        {{ $slot }}
    </div>
</form>

@section('section-js')

    <script type="module">
        $(document).ready(function () {
            $(".media-uploader").each(function() {

                let model = $(this).attr("data-model") ?? '';
                let primaryKey = $(this).attr("data-primary-key") ?? '';
                let collection = $(this).attr("data-collection") ?? '';
                let disk = $(this).attr("data-disk") ?? '';

                new Dropzone("#"+$(this).attr('id'), {
                    url: $(this).attr("data-url"), // Set the url for your upload script location
                    paramName: "file", // The name that will be used to transfer the file
                    maxFiles: $(this).attr("data-maxFiles"),
                    maxFilesize: $(this).attr("data-maxFilesize"), // MB
                    addRemoveLinks: true,
                    accept: function(file, done) {
                        if (file.name == "wow.jpg") {
                            done("Naha, you don't.");
                        } else {
                            done();
                        }
                    },
                    sending: function(file, xhr, formData) {
                        formData.append("_token", $('meta[name="csrf-token"]').attr('content'));
                        formData.append("model", model);
                        formData.append("primaryKey", primaryKey);
                        formData.append("collection", collection);
                        formData.append("disk", disk);
                    },
                });
            });
        });
    </script>
@endsection
