<div class="col-md-{{ $field->size() ?? 12 }}">
    <div class="form-group fv-row mb-5">
        <label for="{{ $field->name() }}">
            {{ $field->title() }}:
            {{ ($field->required() ? '*' : '') }}
        </label>
        <div class="<!--input-group-->">
            @if($field->icon())
                <span class="input-group-text">
                    {!! $field->icon() !!}
                </span>
            @endif
            <textarea
                type="text"
                {{ $field->readonly() ? 'readonly' : '' }}
                {{ $field->disabled() ? 'disabled' : '' }}
                name="{{ $field->name() }}"
                class="form-control
                @if($field->validation_status() !== '')
                    {{ $field->validation_status() === 'valid' ? 'is-valid' : 'is-invalid' }}
                @endif
                {{ $field->class() }}"
            >{!! $field->value() !!}</textarea>
                @if($field->description() != '')
                    <div class="text-muted fs-7">{{ $field->description() }}</div>
                @endif
            <x-form-validation-error name="{{ $field->request_name() }}" />
        </div>
    </div>
</div>
