<div class="col-md-{{ $field->size() ?? 12 }}">
    <div class="{{ $field->parent_class() }}">
        @if(! $field->label_position() || $field->label_position() == 'top')
            <label for="{{ $field->name() }}">
                {{ $field->title() }}:
                {{ ($field->required() ? '*' : '') }}
            </label>
        @endif

            @if($field->icon())
                <span class="input-group-text">
                    {!! $field->icon() !!}
                </span>
            @endif
            <input
                type="text"
                @if($field->placeholder())
                    placeholder="{{ $field->title() }}"
                @endif
                {{ $field->readonly() ? 'readonly' : '' }}
                {{ $field->disabled() ? 'disabled' : '' }}
                name="{{ $field->name() }}"
                class="form-control
                @if($field->validation_status() !== '')
                    {{ $field->validation_status() === 'valid' ? 'is-valid' : 'is-invalid' }}
                @endif
                {{ $field->class() }}"
                value="{{ $field->value() }}"
            />

            @if($field->description() != '')
                <div class="text-muted fs-7">{{ $field->description() }}</div>
            @endif

                @if($field->label_position() == 'bottom')
                    <label for="{{ $field->name() }}">
                        {{ $field->title() }}:
                        {{ ($field->required() ? '*' : '') }}
                    </label>
                @endif

            <x-form-validation-error name="{{ $field->request_name() }}" />
    </div>
</div>
