@foreach(\ViartasCore\Core\Facades\Viartas::driver()->locale()->all() as $locale)
    @php
        $value = $field->value();
        if (is_array($field->value())) {
            $value = $field->value()[$locale->tag] ?? '';
        }
    @endphp
    <div class="col-md-{{ $field->size() ?? 12 }}" x-show="locale === '{{ $locale->tag }}'">
        <div class="form-group fv-row mb-5">
            <label for="{{ $field->request_name().'['.$locale->tag.']' }}">
                {{ $field->title() }} ({{ $locale->tag }}):
                {{ ($field->required() ? '*' : '') }}
            </label>
            <div class="<!--input-group -->fv-row">
                @if($field->icon())
                    <span class="input-group-text">
                        {!! $field->icon() !!}
                    </span>
                @endif
                <input
                    type="text"
                    {{ $field->readonly() ? 'readonly' : '' }}
                    {{ $field->disabled() ? 'disabled' : '' }}
                    name="{{ $field->request_name().'['.$locale->tag.']' }}"
                    class="form-control
                    @if($errors->any())
                        {{ !$errors->has($field->request_name().'.'.$locale->tag) && !$errors->get($field->request_name()) ? 'is-valid' : 'is-invalid' }}
                    @endif
                    {{ $field->class() }}"
                    value="{{ $value }}"
                />
                @if($field->description() != '')
                    <div class="text-muted fs-7">{{ $field->description() }}</div>
                @endif

                @if($errors->has($field->request_name()))
                    <x-form-validation-error name="{{ $field->request_name() }}" />
                @endif
                <x-form-validation-error name="{{ $field->request_name().'.'.$locale->tag }}" />
            </div>
        </div>
    </div>
@endforeach
