<div class="col-md-{{ $field->size() ?? 12 }}">
     <div class="{{ $field->parent_class() }}">
         @if(! $field->label_position() || $field->label_position() == 'top')
             <label for="{{ $field->name() }}">
                 {{ $field->title() }}:
                 {{ ($field->required() ? '*' : '') }}
             </label>
         @endif

             @if($field->icon())
                 <span class="input-group-text">
                     {{ $field->icon() }}
                 </span>
             @endif
             <select
                 {{ $field->readonly() ? 'readonly' : '' }}
                 {{ $field->disabled() ? 'disabled' : '' }}
                 {{ $field->multiple() ? 'multiple' : '' }}
                 name="{{ $field->name() }}"
                 class="form-select
                 @if($field->validation_status() !== '')
                    {{ $field->validation_status() === 'valid' ? 'is-valid' : 'is-invalid' }}
                 @endif
                 {{ $field->class() }}"
             >
                 <option {{ ($field->required() && $field->multiple() ? 'disabled' : '') }} value="">{{ __('Select') }} {{ $field->title() }}</option>
                 @if($field->options() && is_array($field->options()))
                     @foreach($field->options() as $key => $v)
                         @php
                             $selected = '';
                             if (is_array($field->value()) && in_array($key, $field->value())) {
                                 $selected = 'selected';
                             }

                             if (!is_array($field->value()) && $key == $field->value()) {
                                 $selected = 'selected';
                             }
                         @endphp
                         <option value="{{ $key }}" {{ $selected }}>{{ $v }}</option>
                     @endforeach
                 @endif
                 @if($field->options() && !is_array($field->options()))
                     @foreach ($field->options() as $element)
                         <x-form-nested-select-options :element="$element" :field="$field" :depth="0" />
                     @endforeach
                 @endif
             </select>

                 @if($field->description() != '')
                     <div class="text-muted fs-7">{{ $field->description() }}</div>
                 @endif

                 @if($field->label_position() == 'bottom')
                     <label for="{{ $field->name() }}">
                         {{ $field->title() }}:
                         {{ ($field->required() ? '*' : '') }}
                     </label>
                 @endif

                 <x-form-validation-error name="{{ $field->request_name() }}" />

     </div>
</div>
