<div class="col-md-{{ $field->size() ?? 12 }}">
    <div class="{{ $field->parent_class() }}">
        @if($field->title() != '')
            <label>
                {{ $field->title() }}:
                {{ ($field->required() ? '*' : '') }}
            </label>
        @endif
        @if($field->options())
            @foreach($field->options() as $key => $v)
                @php
                    $checked = '';
                    if (is_array($field->value()) && in_array($key, $field->value())) {
                        $checked = 'checked';
                    }

                    if (!is_array($field->value()) && $key == $field->value()) {
                        $checked = 'checked';
                    }
                @endphp
                <div class="form-check mb-3 {{ ($field->inline() ? 'd-inline-block min-w-100px mx-3' : '') }}">
                    <input
                        class="
                            form-check-input {{ $field->class() }}
                            @if($field->validation_status() !== '')
                                {{ $field->validation_status() === 'valid' ? 'is-valid' : 'is-invalid' }}
                            @endif"
                        type="checkbox"
                        name="{{ $field->name() }}"
                        id="{{ $field->request_name() }}_{{ $key }}"
                        value="{{ $key }}"
                        {{ $field->readonly() ? 'readonly' : '' }}
                        {{ $field->disabled() ? 'disabled' : '' }}
                        {{ $checked }}
                    >
                    <label class="form-check-label" for="{{ $field->request_name() }}_{{ $key }}">
                        {{ $v }}
                    </label>
                    @if($field->description() != '')
                        <div class="text-muted fs-7">{{ $field->description() }}</div>
                    @endif
                    <x-form-validation-error name="{{ $field->request_name() }}" />
                </div>
            @endforeach
        @endif
    </div>
</div>

{{--

<div class="col-md-{{ $field->size() ?? 12 }}">
     <div class="form-group fv-row mb-5">
         <label for="{{ $field->name() }}">{{ $field->title() }}:*</label>
         <div class="input-group">
             @if($field->icon())
                 <span class="input-group-text">
                     {{ $field->icon() }}
                 </span>
             @endif
             <select
                 {{ $field->readonly() ? 'readonly' : '' }}
                 {{ $field->disabled() ? 'disabled' : '' }}
                 {{ $field->multiple() ? 'multiple' : '' }}
                 name="{{ $field->name() }}"
                 class="form-select
                 @if($field->validation_status() !== '')
                    {{ $field->validation_status() === 'valid' ? 'is-valid' : 'is-invalid' }}
                 @endif
                 {{ $field->class() }}"
             >
                 <option {{ ($field->required() && $field->multiple() ? 'disabled' : '') }} value="">{{ __('Select') }} {{ $field->title() }}</option>
                 @if($field->options())
                     @foreach($field->options() as $key => $v)
                         @php
                             $selected = '';
                             if (is_array($field->value()) && in_array($key, $field->value())) {
                                 $selected = 'selected';
                             }

                             if (!is_array($field->value()) && $key == $field->value()) {
                                 $selected = 'selected';
                             }
                         @endphp
                         <option value="{{ $key }}" {{ $selected }}>{{ $v }}</option>
                     @endforeach
                 @endif
             </select>
                 <x-form-validation-error name="{{ $field->request_name() }}" />
         </div>
     </div>
</div>
--}}
