<?php

namespace ViartasBuilders\Contents\Providers;

use Illuminate\Support\Facades\Blade;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\View;
use Illuminate\Support\ServiceProvider;

class ContentsBuilderServiceProvider extends ServiceProvider
{
    protected string $viewLocation = 'Bootstrap5';

    public function register()
    {

    }

    public function boot()
    {
        $this->collectComponents(__DIR__ . '/../Components');
    }

    public function loadAnonymousComponents()
    {
        Blade::anonymousComponentPath(
            __DIR__ . '/Components/view',
            'form'
        );
    }

    protected function collectComponents($componentsFolder): void
    {
        $components = [];

        View::addLocation(__DIR__ . '/../Components/' .$this->viewLocation);
        $componentsViews = File::allFiles($componentsFolder.'/'.$this->viewLocation);

        foreach ($componentsViews as $component) {

            $alias = substr($component->getRelativePathname(),0, -10);
            //$name = preg_replace('/^(content-)/', '', $alias);
            $name = $alias;

            $name = explode("-", $name);

            foreach ($name as $key => $value) {
                $name[$key] = ucfirst($value);
            }

            $name = implode('', $name);
            $components[$alias] = 'ViartasBuilders\\Contents\\Components\\'.$name.'Component';
        }

        Blade::components($components);
    }
}
